﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlaneShoot : MonoBehaviour {

    public GameObject player, enemyBullet;
    
    public float timeToShoot;
    public float timeToShootNext;

	void Start () {
        player = GameObject.FindGameObjectWithTag("Player");
	}
	
	void Update () {
        float distance = Vector3.Distance(transform.position, player.transform.position);

        if (distance < 10) {
            AttackPlayer();
        }       	
	}

    void AttackPlayer() {
        if (Time.time >= timeToShoot) {
            EnemyPlaneShoot();
            timeToShoot = Time.time + timeToShootNext;
        }
    }

    public void EnemyPlaneShoot() {
         Instantiate(enemyBullet, transform.position, transform.rotation);
    }
}
